<?php
// счетчики статистики
if(!defined('ANTIBOT')) die('access denied');

$title = abTranslate('Statistics');

// перенос статистики из файлов в базу:
$cron_update_time = (int) trim(@file_get_contents(__DIR__.'/../data/counters/update')) + 0;
if ($ab_config['time'] - $cron_update_time > 600) {
file_put_contents(__DIR__.'/../data/counters/update', $ab_config['time'], LOCK_EX);
require_once(__DIR__.'/../code/cron.php');
$cron_update_time = $ab_config['time'];
}

$list = $antibot_db->query("SELECT * FROM counters ORDER BY date DESC LIMIT 30;"); 

$content .= '<p>'.abTranslate('Until the next update statistics remains:').' '.(600 - ($ab_config['time'] - $cron_update_time)).' '.abTranslate('sec.').'</p>
<div class="table-responsive">
<table class="table table-bordered table-hover table-sm">
<thead class="thead-light">
<tr>
<th><small>'.abTranslate('Date').'</small></th>
<th style="color:red;"><small>STOP</small></th>
<th style="color:green;"><small>AUTO</small></th>
<th style="color:green;"><small>POST</small></th>
<th style="color:green;"><small>ALLOW</small></th>
<th style="color:blue;"><small>GOODIP</small></th>
<th style="color:red;"><small>BLOCK</small></th>
<th style="color:red;"><small>FAKE</small></th>
<th><small>LOCAL</small></th>
<th><small>'.abTranslate('Unique').'</small></th>
<th><small>'.abTranslate('Hits').'</small></th>
<th><small>'.abTranslate('GoogleBot').'</small></th>
<th><small>'.abTranslate('YandexBot').'</small></th>
<th><small>'.abTranslate('BingBot').'</small></th>
</tr>
</thead>
<tbody>
';
$all_no = 0;
$all_auto = 0;
$all_post = 0;
$all_allow = 0;
$all_goodip = 0;
$all_uusers = 0;
$all_husers = 0;
$all_google = 0;
$all_yandex = 0;
$all_bing = 0;
$all_block = 0;
$all_fakes = 0;
$all_local = 0;
while ($echo = $list->fetchArray(SQLITE3_ASSOC)) {
$no = $echo['test'] - $echo['auto'] - $echo['post'];

$content .= '<tr>
<td>'.date("Y.m.d", strtotime($echo['date'])).'</td>
<td>'.number_format($no).'</td>
<td>'.number_format($echo['auto']).'</td>
<td>'.number_format($echo['post']).'</td>
<td>'.number_format($echo['allow']).'</td>
<td>'.number_format($echo['goodip']).'</td>
<td>'.number_format($echo['block']).'</td>
<td>'.number_format($echo['fakes']).'</td>
<td>'.number_format($echo['local']).'</td>
<td>'.number_format($echo['uusers']).'</td>
<td>'.number_format($echo['husers']).'</td>
<td>'.number_format($echo['google']).'</td>
<td>'.number_format($echo['yandex']).'</td>
<td>'.number_format($echo['bing']).'</td>
</tr>';
$all_no = $all_no + $no;
$all_auto = $all_auto + $echo['auto'];
$all_post = $all_post + $echo['post'];
$all_allow = $all_allow + $echo['allow'];
$all_goodip = $all_goodip + $echo['goodip'];
$all_uusers = $all_uusers + $echo['uusers'];
$all_husers = $all_husers + $echo['husers'];
$all_google = $all_google + $echo['google'];
$all_yandex = $all_yandex + $echo['yandex'];
$all_bing = $all_bing + $echo['bing'];
$all_block = $all_block + $echo['block'];
$all_fakes = $all_fakes + $echo['fakes'];
$all_local = $all_local + $echo['local'];
}

if ($all_auto == 0) {
$all_percent = 0;
} else {
$all_percent = round($all_post * 100 / $all_auto);
}

$content .= '
<tr>
<td><strong>Total</strong></td>
<td>'.number_format($all_no).'</td>
<td>'.number_format($all_auto).'</td>
<td>'.number_format($all_post).'</td>
<td>'.number_format($all_allow).'</td>
<td>'.number_format($all_goodip).'</td>
<td>'.number_format($all_block).'</td>
<td>'.number_format($all_fakes).'</td>
<td>'.number_format($all_local).'</td>
<td>'.number_format($all_uusers).'</td>
<td>'.number_format($all_husers).'</td>
<td>'.number_format($all_google).'</td>
<td>'.number_format($all_yandex).'</td>
<td>'.number_format($all_bing).'</td>
</tr>
</tbody>
</table>
</div>
<p><strong style="color:red;">STOP</strong> - '.abTranslate('visitors who have not passed the antibot check.').'<br />
<strong style="color:green;">AUTO</strong> - '.abTranslate('visitors who successfully passed the test.').'<br />
<strong style="color:green;">POST</strong> - '.abTranslate('visitors who did not pass the automatic check, but clicked on the button.').'<br />
<strong style="color:green;">ALLOW</strong> - '.abTranslate('visitors who have passed without checking according to the permit rules.').'<br />
<strong style="color:blue;">GOODIP</strong> - '.abTranslate('bots allowed in the config (search engine bots) and in the ip rules.').'<br />
<strong style="color:red;">BLOCK</strong> - '.abTranslate('blocked hits according to your rules (by ip, country, language, referrer, ptr).').'<br />
<strong style="color:red;">FAKE</strong> - '.abTranslate('hits by fake bots that disguise themselves as good bots.').'<br />
<strong>'.abTranslate('Unique').'</strong> - '.abTranslate('unique visitors (unique IP) recorded by JS counter.').'<br />
<strong>'.abTranslate('Hits').'</strong> - '.abTranslate('visitor views recorded by JS counter.').'
</p>
<hr />
<p>'.abTranslate('Counter code for counting uniques and hits. This code must be inserted into your website template.').'</p>
<textarea class="form-control" rows="5"><script>
var abc = new XMLHttpRequest();
var microtime = Date.now();
var abcbody = "t="+microtime+"&w="+screen.width+"&h="+ screen.height+"&cw="+document.documentElement.clientWidth+"&ch="+document.documentElement.clientHeight;
abc.open("POST", "'.$ab_config['webdir'].'8.php", true);
abc.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
abc.send(abcbody);
</script></textarea>
';
