<?php
// admin panel
set_time_limit(900);
ignore_user_abort(true);
header('Content-Type: text/html; charset=UTF-8');
header('X-Powered-CMS: AntiBot.Cloud (See: https://antibot.cloud/)');
header('X-Robots-Tag: noindex');
header('Expires: Thu, 18 Aug 1994 05:00:00 GMT');
header('Cache-Control: no-store, no-cache, must-revalidate');
define('ANTIBOT', 1);
define('ANTIBOT_ADMIN', 1);

$start_time = microtime(true);
$ab_config['cms'] = 'antibot';
$abp = 'abp';
$abp_get = array(); // добавочные гет переменные
$abw = '';
foreach ($abp_get as $k => $v) {
$abw .= $k.'='.$v.'&'; // подставлять в урл
}

require_once(__DIR__.'/code/include.php');

$ab_webdir = dirname($ab_config['uri']); // веб путь до папки антибота (без закрывающего слэша)

$host = isset($_SERVER['HTTP_HOST']) ? preg_replace("/[^0-9a-z-.:]/","", $_SERVER['HTTP_HOST']) : '';
$lang_code = isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? mb_substr(mb_strtolower(trim(preg_replace("/[^a-zA-Z]/","",$_SERVER['HTTP_ACCEPT_LANGUAGE'])), 'UTF-8'), 0, 2, 'utf-8') : 'en'; // 2 первых символа
//$lang_code = isset($_COOKIE['lang_code']) ? mb_substr(mb_strtolower(trim(preg_replace("/[^a-zA-Z]/","",$_COOKIE['lang_code'])), 'UTF-8'), 0, 2, 'utf-8') : $lang_code;

if ($lang_code == 'uk' OR $ab_config['country'] == 'RU' OR $ab_config['country'] == 'BY' OR $ab_config['country'] == 'UA' OR $ab_config['country'] == 'KZ') {
$lang_code = 'ru';
}

// перевод на язык посетителя:
if (file_exists(__DIR__.'/lang/adm/'.$lang_code.'.php')) {
require_once(__DIR__.'/lang/adm/'.$lang_code.'.php');
} else {
$lang_code = 'en';
}

if ($ab_config['email'] == '' OR $ab_config['pass'] == '') die('EMAIL or PASS not set in '.__DIR__.'/data/conf.php');

// пост запрос авторизации (установки cookie):
if (isset($_POST['auth_post'])) {
$auth_user = isset($_POST['auth_user']) ? trim($_POST['auth_user']) : ''; // email
$auth_pass = isset($_POST['auth_pass']) ? trim($_POST['auth_pass']) : ''; // pass
$auth_second_pass = isset($_POST['auth_second_pass']) ? trim($_POST['auth_second_pass']) : ''; // second pass
if ($auth_second_pass != '') {$auth_second_pass = md5('antibot'.$auth_second_pass);}

$token = md5($auth_user.$ab_config['accept_lang'].$ab_config['useragent'].$ab_config['ip'].$auth_pass.$ab_config['host'].$ab_config['salt'].$auth_second_pass); // токен, основанный на post данных

if ($ab_config['secondpass'] != '' AND $ab_config['secondpass'] != $auth_second_pass) {
$token = 'badsecondpass';
}
setcookie('auth_admin_token', $token, $ab_config['time']+864000, '/');
} else {
$token = isset($_COOKIE['auth_admin_token']) ? trim($_COOKIE['auth_admin_token']) : ''; // token из cookie
}

// проверка авторизации:
if ($token != md5($ab_config['email'].$ab_config['accept_lang'].$ab_config['useragent'].$ab_config['ip'].$ab_config['pass'].$ab_config['host'].$ab_config['salt'].$ab_config['secondpass'])) {
require_once(__DIR__.'/code/loginform.php');
die();
}

// если включен демо режим, то ничего нельзя изменять:
if ($ab_config['demo'] == 1 AND $_SERVER['REQUEST_METHOD'] == 'POST') {
echo '<script>document.location.href="?'.$abw.$abp.'=index";</script>';
die();
}

$content = '';
// страница админки
$page = isset($_GET[$abp]) ? preg_replace("/[^0-9a-z]/","",trim($_GET[$abp])) : 'index';
if (!file_exists(__DIR__.'/adm/'.$page.'.php')) {$page = 'index';}
require_once(__DIR__.'/adm/'.$page.'.php');

echo '<!DOCTYPE html>
<html lang="'.abTranslate('en').'">
<head>
<title>'.$title.' - '.$host.'</title>
<meta charset="utf-8">
<meta name="referrer" content="unsafe-url" />
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
<link rel="stylesheet" href="'.$ab_config['webdir'].'static/freakflags.css">
<style>
body {overflow-y: scroll;}
.pngflag {height: 16px; border: 1px solid #C0C0C0;}
</style>
</head>
<body class="bg-light">
<main role="main" class="container">
<nav class="my-3 navbar navbar-dark bg-dark rounded shadow-sm">
  <a class="navbar-brand" href="/">'.$host.' <sup><small>'.$ab_version.'</small></sup></a>
<span class="navbar-text"> 
<!--
<a href="?'.$abw.$abp.'=lang&lang=ru&rand='.$start_time.'" title="на Русском"><div class="fflag fflag-RU ff-lg"></div></a> 
<a href="?'.$abw.$abp.'=lang&lang=en&rand='.$start_time.'" title="in English"><div class="fflag fflag-US ff-lg"></div></a> 
-->
</span>
</nav>

<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
<li class="breadcrumb-item"><a href="?'.$abw.$abp.'=index" '.(($page == 'index') ? 'class="text-secondary"' : '').'>'.abTranslate('Home').'</a></li>
<li class="breadcrumb-item"><a href="?'.$abw.$abp.'=top" '.(($page == 'top') ? 'class="text-secondary"' : '').'>'.abTranslate('Top').'</a></li>
<li class="breadcrumb-item"><a href="?'.$abw.$abp.'=counters" '.(($page == 'counters') ? 'class="text-secondary"' : '').'>'.abTranslate('Statistics').'</a></li>
<li class="breadcrumb-item"><a href="?'.$abw.$abp.'=rules" '.(($page == 'rules') ? 'class="text-secondary"' : '').'>'.abTranslate('Rules').'</a></li>
<li class="breadcrumb-item"><a href="?'.$abw.$abp.'=hits" '.(($page == 'hits') ? 'class="text-secondary"' : '').'>'.abTranslate('Query Log').'</a></li>
<li class="breadcrumb-item"><a href="?'.$abw.$abp.'=conf" '.(($page == 'conf') ? 'class="text-secondary"' : '').'>conf.php</a></li>
<li class="breadcrumb-item"><a href="?'.$abw.$abp.'=tpl" '.(($page == 'tpl') ? 'class="text-secondary"' : '').'>tpl.txt</a></li>
<li class="breadcrumb-item"><a href="?'.$abw.$abp.'=error" '.(($page == 'error') ? 'class="text-secondary"' : '').'>error.txt</a></li>
<li class="breadcrumb-item"><a href="?'.$abw.$abp.'=update" '.(($page == 'update') ? 'class="text-secondary"' : '').'>'.abTranslate('Update').'</a></li>
<li class="breadcrumb-item"><a href="?'.$abw.$abp.'=exit&rand='.$start_time.'">'.abTranslate('Log out').'</a></li>
</ol>
</nav>';

echo '<div class="my-3 p-3 bg-white rounded shadow-sm">
';
if ($ab_config['demo'] == 1) {
echo '<div class="alert alert-warning" role="alert">
<i class="bi bi-exclamation-triangle-fill"></i> '.abTranslate('The admin panel is in demo mode. The ability to make changes (delete data, change settings) is disabled.').'
</div>';
}
echo $content;
$exec_time = microtime(true) - $start_time;
$exec_time = round($exec_time, 2);
echo '</div></main>
<br />
<footer class="container border-top text-center text-muted">
        <div class="row">
          <div class="col-12">
<small>
Powered by <a href="https://antibot.cloud/'.$lang_code.'.html" target="_blank" rel="noopener noreferrer">AntiBot.Cloud</a> | 
Support: <a href="mailto:support@antibot.cloud?subject=AntiBot: '.$ab_config['host'].'" target="_blank">support@antibot.cloud</a> | 
<a href="https://antibot.cloud/FAQ.php?lang='.$lang_code.'" target="_blank" rel="noopener noreferrer">FAQ</a> | 
<a href="https://twitter.com/AntiBotCloud" target="_blank" rel="noopener">Twitter</a> | 
<a href="'.abTranslate('https://t.me/AntiBotCloudSupport').'" target="_blank" rel="noopener">Telegram</a> | 
Server Time: '.date('Y.m.d H:i:s', $ab_config['time']).' | 
Execution Time: '.$exec_time.' Sec.<br />
</small>
</div>
</div>
      </footer>
<br />
<script>function check() { return confirm("'.abTranslate('Delete records exactly?').'") }</script>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>';
