<?php
// главная страница админки
if(!defined('ANTIBOT')) die('access denied');

$title = abTranslate('Home');

$size = filesize(__DIR__.'/../data/sqlite.db');
if ($ab_config['secondpass'] == '') {
$content .= '<div class="alert alert-danger" role="alert">'.abTranslate('You have not set an Second Password.').' <a href="?'.$abw.$abp.'=conf#secondpass">'.abTranslate('Set password.').'</a> '.abTranslate('This will reduce the risk of hacking the antibot control panel.').'</div>';
}
if (!file_exists(__DIR__.'/../data/cronlog')) {
$content .= '<div class="alert alert-danger" role="alert">'.abTranslate('Set up a CRON job to automatically remove old entries from the Query Log:').'<br />
<code>0 1 * * * /usr/bin/php -q '.dirname(dirname(__FILE__)).'/code/clear_old_hits.php > /dev/null 2>&1</code>
<br /><small>'.abTranslate('Check with your hosting provider on how to run a php script in a crontab.').'</small></div>';
}
$content .= '
<span id="warning"></span>
<span id="auth_msg"></span>
<div id="new_version_msg" class="alert alert-success" role="alert" style="display:none">'.abTranslate('A new version of the antibot is now available. In order to upgrade, visit page:').' <a href="?'.$abw.$abp.'=update">'.abTranslate('Update').'</a></div>
<p><div class="fflag fflag-'.$ab_config['country'].' ff-md" title="'.$ab_config['country'].'"></div> <strong>'.$ab_config['ip'].'</strong> - '.abTranslate('Is this your IP?').' <a href="?'.$abw.$abp.'=proxy">'.abTranslate('If not, then you need to configure it.').'</a></p>
';
if(function_exists('sys_getloadavg')) {
$content .= '<p>Load average: ';
foreach(sys_getloadavg() as $la) {$content .= round($la, 2).' ';}
$content .= '</p>';
}
$content .= '<p>'.abTranslate('Database file size:').' sqlite.db: '.round($size / 1024 / 1024, 2).' MiB [<a href="?'.$abw.$abp.'=backup">'.abTranslate('Backup').'</a>]</p>
<hr />
';

if (file_exists(__DIR__.'/../data/errorlog.txt')) {
$phperrorsize = filesize(__DIR__.'/../data/errorlog.txt');
$content .= '<p class="text-danger">PHP error log: '.abTranslate('file size').' '.round($phperrorsize / 1024 / 1024, 2).' MiB - '.abTranslate('We have problems!').'</p>';
if ($phperrorsize < 1500) {$indent = $phperrorsize;} else {$indent = 1500;}
$last_lines = strip_tags(file_get_contents(__DIR__.'/../data/errorlog.txt', FALSE, NULL, ($phperrorsize-$indent)));
if ($indent == 1500) {
$last_lines = explode("\n", $last_lines, 2);
$last_lines = $last_lines[1];
}
$content .= '<pre>'.$last_lines.'</pre>
<small class="form-text text-muted">'.abTranslate('These are the last 1500 bytes of the log, maybe there are more lines in it. All log is in data/errorlog.txt').'</small>
<form action="?'.$abw.$abp.'=removephperrorlog" method="post" onsubmit="return check()"><input style="cursor:pointer;" type="submit" name="removephperrorlog_submit" class="btn btn-link btn-sm" value="'.abTranslate('Delete log file').'"></form>
';
} else {
$content .= '<p class="text-success">PHP error log: '.abTranslate('The file does not exist and that\'s good!').'</p>';
}

$content .= '<hr />
<p>Last cron log:</p>
<pre>'.@file_get_contents(__DIR__.'/../data/cronlog').'</pre>
<hr />
';

// новости:
$content .= '<span id="other_ab_msg"></span>';

$content .= '<script>var current_version = '.$ab_version.';</script>
<script src="https://antibot.cloud/version8.php?h1='.hash('sha256', $ab_config['email'].$ab_config['pass'].$ab_config['useragent'].$ab_config['accept_lang'].$ab_config['time']).'&h2='.md5('Antibot:'.$ab_config['email']).'&date='.$ab_config['time'].'&v='.$ab_version.'&lang='.$lang_code.'" async></script>

<script>
var xmlhttp = new XMLHttpRequest();
xmlhttp.onreadystatechange = function() {
if (this.readyState == 2 && this.status == 200) {
document.getElementById("warning").innerHTML = "<div class=\"alert alert-danger\"><a href=\"data/sqlite.db\" target=\"_blank\">data/sqlite.db</a> - '.abTranslate('The database file has a server response code of 200. It may be available for download. This is unsafe because the database may contain confidential data. Protect the database file from web access.').' '.abTranslate('If you are using NGINX, then to deny access to the database, use the following code: <code>location ~ \\\.db { deny all; }</code> which needs to be added to the Nginx domain config.').'</div>";
}
};
xmlhttp.timeout = 1000;
xmlhttp.open("GET", "data/sqlite.db", true);
xmlhttp.send();
</script>
';
