<?php
// лог обращений
if(!defined('ANTIBOT')) die('access denied');

$title = abTranslate('Query Log');

// номер страницы пагинации:
$n = isset($_GET['n']) ? preg_replace("/[^0-9]/","",trim($_GET['n'])) : 0;

$search = isset($_GET['search']) ? trim(strip_tags($_GET['search'])) : '';
$search = $antibot_db->escapeString($search);
$table = isset($_GET['table']) ? preg_replace("/[^a-z\_]/","",trim($_GET['table'])) : '';
$status = isset($_GET['status']) ? preg_replace("/[^0-9]/","",trim($_GET['status'])) : '';
$operator = isset($_GET['operator']) ? preg_replace("/[^a-z]/","",trim($_GET['operator'])) : '';
$todate = isset($_GET['todate']) ? preg_replace("/[^a-z]/","",trim($_GET['todate'])) : '';
$delete = isset($_GET['delete']) ? preg_replace("/[^0-9]/","",trim($_GET['delete'])) : '0';

// искать до указанной даты
$tl['lastday'] = $ab_config['time'] - 86400; // сутки
$tl['lastweek'] = $ab_config['time'] - (86400*7); // неделя
$tl['lastmonth'] = $ab_config['time'] - (86400*30); // месяц
$tl['lastyear'] = $ab_config['time'] - (86400*365); // год

if (isset($tl[$todate])) {
$datelimit = 'date >= \''.$tl[$todate].'\' AND';
} else {
$datelimit = '';
}

$search_count = '';

if ($search != '') {
if ($operator == 'equally') {
if ($search == 'null') {
$q = "=''";
} else {
$q = "='".$search."'";
}
} else {$q = "LIKE '%".$search."%'";}

if ($delete == 1 AND $ab_config['demo'] != 1) {
$sql = "DELETE FROM hits WHERE ".$datelimit." ".(($status != '') ? "passed='".$status."' AND" : '')." ".$table." ".$q.";";
$list = $antibot_db->query($sql); 
$content .= '<div class="alert alert-success" role="alert">'.abTranslate('The selection has been deleted.').'</div>';
}

$sql = "SELECT rowid, * FROM hits WHERE ".$datelimit." ".(($status != '') ? "passed='".$status."' AND" : '')." ".$table." ".$q." ORDER BY rowid DESC LIMIT ".$n.", 100;";
//echo '<br />'.$sql;
$list = $antibot_db->query($sql); 

// кол-во результатов выборки:
//$size = round(filesize(__DIR__.'/../data/sqlite.db') / 1024 / 1024, 2);
//if ($size < 1000) {
$search_count = $antibot_db->querySingle("SELECT count(rowid) FROM hits WHERE ".$datelimit." ".(($status != '') ? "passed='".$status."' AND" : '')." ".$table." ".$q." ORDER BY rowid DESC;");
$search_count = (string)$search_count;

$search_count2 = $antibot_db->querySingle("SELECT count(DISTINCT ip) FROM hits WHERE ".$datelimit." ".(($status != '') ? "passed='".$status."' AND" : '')." ".$table." ".$q." ORDER BY rowid DESC;");
$search_count2 = (string)$search_count2;

$search_count = abTranslate('Found matches:').' '.number_format($search_count).'. '.abTranslate('Unique IP:').' '.number_format($search_count2);
//}

} else {
$sql = "SELECT rowid, * FROM hits ".(($status != '') ? "WHERE ".$datelimit." passed='".$status."'" : '')." ORDER BY rowid DESC LIMIT ".$n.", 100;";
//echo '<br />'.$sql;
$list = $antibot_db->query($sql); 

$search_count = $antibot_db->querySingle("SELECT count(rowid) FROM hits ".(($status != '') ? "WHERE ".$datelimit." passed='".$status."'" : '')." ORDER BY rowid DESC;");
$search_count = (string)$search_count;

$search_count2 = $antibot_db->querySingle("SELECT count(DISTINCT ip) FROM hits ".(($status != '') ? "WHERE ".$datelimit." passed='".$status."'" : '')." ORDER BY rowid DESC;");
$search_count2 = (string)$search_count2;

$search_count = abTranslate('Found matches:').' '.number_format($search_count).'. '.abTranslate('Unique IP:').' '.number_format($search_count2);
}

if ($list === false) {
var_dump($antibot_db->lastErrorCode());
var_dump($antibot_db->lastErrorMsg());
@unlink(__DIR__.'/../data/sqlite.dump');
exec('sqlite3 '.__DIR__.'/../data/sqlite.db .dump > '.__DIR__.'/../data/sqlite.dump');
die();
}

$content .= '
<form class="form-inline" action="?'.$abw.$abp.'=hits" method="get">';
foreach ($abp_get as $k => $v) {
$content .= '<input name="'.$k.'" type="hidden" value="'.$v.'">';
}
$content .= '<input name="'.$abp.'" type="hidden" value="hits">
'.abTranslate('Search:').' <input class="form-control mx-sm-3 form-control-sm" name="search" type="text" value="'.(($search != '') ? $search : '').'">
'.abTranslate('status:').'
<select class="form-control mx-sm-3 form-control-sm" name="status">
<option value="">'.abTranslate('any').'</option>
<option value="0" '.(($status == '0') ? 'selected' : '').'>stop</option>
<option value="1" '.(($status == '1') ? 'selected' : '').'>auto</option>
<option value="2" '.(($status == '2') ? 'selected' : '').'>post</option>
<option value="3" '.(($status == '3') ? 'selected' : '').'>local</option>
<option value="4" '.(($status == '4') ? 'selected' : '').'>allow</option>
<option value="5" '.(($status == '5') ? 'selected' : '').'>goodip</option>
<option value="6" '.(($status == '6') ? 'selected' : '').'>block</option>
<option value="7" '.(($status == '7') ? 'selected' : '').'>fake</option>
</select> 
'.abTranslate('table:').'
<select class="form-control mx-sm-3 form-control-sm" name="table">
<option value="ip" '.(($table == 'ip') ? 'selected' : '').'>IP</option>
<option value="ptr" '.(($table == 'ptr') ? 'selected' : '').'>PTR</option>
<option value="useragent" '.(($table == 'useragent') ? 'selected' : '').'>useragent</option>
<option value="uid" '.(($table == 'uid') ? 'selected' : '').'>uid</option>
<option value="cid" '.(($table == 'cid') ? 'selected' : '').'>cid</option>
<option value="country" '.(($table == 'country') ? 'selected' : '').'>country</option>
<option value="referer" '.(($table == 'referer') ? 'selected' : '').'>referer</option>
<option value="page" '.(($table == 'page') ? 'selected' : '').'>page</option>
<option value="lang" '.(($table == 'lang') ? 'selected' : '').'>lang</option>
<option value="recaptcha" '.(($table == 'recaptcha') ? 'selected' : '').'>recaptcha score</option>
<option value="js_w" '.(($table == 'js_w') ? 'selected' : '').'>monitor width</option>
<option value="js_h" '.(($table == 'js_h') ? 'selected' : '').'>monitor height</option>
<option value="js_cw" '.(($table == 'js_cw') ? 'selected' : '').'>window width</option>
<option value="js_ch" '.(($table == 'js_ch') ? 'selected' : '').'>window height</option>
<option value="js_co" '.(($table == 'js_co') ? 'selected' : '').'>colordepth</option>
<option value="js_pi" '.(($table == 'js_pi') ? 'selected' : '').'>pixeldepth</option>
<option value="refhost" '.(($table == 'refhost') ? 'selected' : '').'>refhost</option>
<option value="asnum" '.(($table == 'asnum') ? 'selected' : '').'>asnum</option>
<option value="asname" '.(($table == 'asname') ? 'selected' : '').'>asname</option>
<option value="result" '.(($table == 'result') ? 'selected' : '').'>result</option>
<option value="http_accept" '.(($table == 'http_accept') ? 'selected' : '').'>http_accept</option>
<option value="method" '.(($table == 'method') ? 'selected' : '').'>http method</option>
<option value="ym_uid" '.(($table == 'ym_uid') ? 'selected' : '').'>yandex clientid</option>
<option value="ga_uid" '.(($table == 'ga_uid') ? 'selected' : '').'>ga clientid</option>
</select>
<select class="form-control mx-sm-3 form-control-sm" name="operator">
<option value="equally" '.(($operator == 'equally') ? 'selected' : '').'>'.abTranslate('Strictly equal').'</option>
<option value="contains" '.(($operator == 'contains') ? 'selected' : '').'>'.abTranslate('Contains').'</option>
</select>
<select class="form-control mx-sm-3 form-control-sm" name="todate">
<option value="lastday" '.(($todate == 'lastday') ? 'selected' : '').'>'.abTranslate('Last Day').'</option>
<option value="lastweek" '.(($todate == 'lastweek') ? 'selected' : '').'>'.abTranslate('Last Week').'</option>
<option value="lastmonth" '.(($todate == 'lastmonth') ? 'selected' : '').'>'.abTranslate('Last Month').'</option>
<option value="lastyear" '.(($todate == 'lastyear') ? 'selected' : '').'>'.abTranslate('Last Year').'</option>
<option value="" '.(($todate == '') ? 'selected' : '').'>'.abTranslate('All time').'</option>
</select> 

<input style="cursor:pointer;" class="btn btn-sm btn-primary" type="submit" name="submit" value="'.abTranslate('Search').'">
</form>
<small><span class="text-secondary">'.abTranslate('To search for empty values, enter in the form: null').'</span></small>
<br />
<p><span class="float-left">'.$search_count.'</span>';
if ($delete != 1 AND $search != '') {
$content .= ' <span class="float-right"><a href="'.$ab_config['uri'].'&delete=1" class="badge badge-danger" onclick="return check()">'.abTranslate('Delete this selection').'</a></span>';
}
$content .= '</p>
<div class="table-responsive">
<table class="table table-bordered table-hover table-sm">
<thead class="thead-light">
<tr>
<th>'.abTranslate('Status').'</th>
<th>IP (PTR) & User Agent & Accept Language</th>
<th>Referer & Page & UID</th>
</tr>
</thead>
<tbody>
';
$i = 0;
while ($echo = $list->fetchArray(SQLITE3_ASSOC)) {
if ($echo['passed'] == 0) {$passed = '<span style="color:red;">STOP</span>';} 
elseif ($echo['passed'] == 1) {$passed = '<span style="color:green;">AUTO</span>';} 
elseif ($echo['passed'] == 2) {$passed = '<span style="color:teal;">POST</span>';} 
elseif ($echo['passed'] == 3) {$passed = '<span style="color:black;">LOCAL</span>';}
elseif ($echo['passed'] == 4) {$passed = '<span style="color:green;">ALLOW</span>';}
elseif ($echo['passed'] == 5) {$passed = '<span style="color:blue;">GOODIP</span>';}
elseif ($echo['passed'] == 6) {$passed = '<span style="color:red;">BLOCK</span>';}
elseif ($echo['passed'] == 7) {$passed = '<span style="color:red;">FAKE</span>';}
if ($echo['adblock'] == 1) {$echo['adblock'] = '<img src="static/abp.png" style="height: 18px;" title="AdBlock detected"/>';} else {$echo['adblock'] = '';}
$content .= '<tr>
<td><small>'.date("Y.m.d H:i:s", $echo['date']).'</small><br />
<strong>'.$passed.'</strong> '.round($echo['generation'], 3);
if ($echo['recaptcha'] == 0) {$echo['recaptcha'] = 'n/a';}
$content .= '<br /><small><span class="text-secondary">
M:'.$echo['js_w'].'☓'.$echo['js_h'].'<br />
B:'.$echo['js_cw'].'☓'.$echo['js_ch'].'<br />
<!--'.$echo['js_co'].' '.$echo['js_pi'].'<br />-->
RE score: '.$echo['recaptcha'].'<br />
</span></small>
</td>
<td style="word-break: break-all;">'.$echo['adblock'].' <div class="fflag fflag-'.$echo['country'].' ff-lg" title="'.$echo['country'].'"></div> <strong>'.$echo['country'].'</strong> <a href="?'.$abw.$abp.'=hits&search='.$echo['ip'].'&table=ip&operator=equally" title="'.abTranslate('selection by:').' IP">'.$echo['ip'].'</a> ('.$echo['ptr'].') <a href="?'.$abw.$abp.'=ip&ip='.$echo['ip'].'" target="_blank" rel="noopener">whois</a><br />
<small>'.$echo['useragent'].'<br />
<strong>'.mb_strimwidth($echo['lang'], 0, 2, '', 'utf-8').'</strong> ('.$echo['lang'].')<br />
<span class="text-secondary">'.$echo['http_accept'].'</span><br />
<span class="text-secondary">AS Num:</span> '.$echo['asnum'].', <span class="text-secondary">AS Name:</span> '.$echo['asname'].'<br />
</small>
<span style="color:'.(($echo['passed'] == 4) ? 'green' : 'red').';">'.$echo['result'].'</span></td>
<td style="word-break: break-all;"><small>
Ref: '.(($echo['refhost'] != '') ? '<img src="https://www.google.com/s2/favicons?domain='.$echo['refhost'].'" />' : '').' <a href="'.$echo['referer'].'" target="_blank" rel="noopener noreferrer" title="Referer">'.mb_strimwidth($echo['referer'], 0, 60, '...', 'utf-8').'</a><br />
P: '.$echo['method'].' <a href="'.$echo['page'].'" target="_blank" rel="noopener" title="Page">'.mb_strimwidth($echo['page'], 0, 60, '...', 'utf-8').'</a><br />
uid: <a href="?'.$abw.$abp.'=hits&search='.$echo['uid'].'&table=uid&operator=equally" title="'.abTranslate('selection by:').' UID">'.$echo['uid'].'</a> <br />
cid: '.$echo['cid'].'<br />
YM uid: '.$echo['ym_uid'].'<br />
GA uid: '.$echo['ga_uid'].'
</small></td>
</tr>';
$i++;
}
$content .= '</tbody>
</table>
</div>';
if ($i == 100) {
$content .= '<center><a href="?'.$abw.$abp.'=hits&n='.($n+100).'&status='.$status.'&search='.urlencode($search).'&table='.$table.'&operator='.$operator.'&todate='.$todate.'" class="btn btn-info btn-block">'.abTranslate('Show more').'</a></center>
';
}
$content .= '
<p>
<form action="?'.$abw.$abp.'=clearhits" method="post" style="display: inline-block;" onsubmit="return check()">
<input name="'.$abp.'" type="hidden" value="hits">
<input style="cursor:pointer;" class="btn btn-sm btn-danger" type="submit" name="clearhits_submit" value="'.abTranslate('Empty the records').'">
</form>

<form action="?'.$abw.$abp.'=clearhits" method="post" style="display: inline-block;" onsubmit="return check()">
<input name="'.$abp.'" type="hidden" value="hits">
<input name="todate" type="hidden" value="lastday">
<input style="cursor:pointer;" class="btn btn-sm btn-danger" type="submit" name="clearhits_submit" value="'.abTranslate('Older than a day').'">
</form>

<form action="?'.$abw.$abp.'=clearhits" method="post" style="display: inline-block;" onsubmit="return check()">
<input name="'.$abp.'" type="hidden" value="hits">
<input name="todate" type="hidden" value="lastweek">
<input style="cursor:pointer;" class="btn btn-sm btn-danger" type="submit" name="clearhits_submit" value="'.abTranslate('Older than a week').'">
</form>

<form action="?'.$abw.$abp.'=clearhits" method="post" style="display: inline-block;" onsubmit="return check()">
<input name="'.$abp.'" type="hidden" value="hits">
<input name="todate" type="hidden" value="lastmonth">
<input style="cursor:pointer;" class="btn btn-sm btn-danger" type="submit" name="clearhits_submit" value="'.abTranslate('Older than a month').'">
</form>

<form action="?'.$abw.$abp.'=clearhits" method="post" style="display: inline-block;" onsubmit="return check()">
<input name="'.$abp.'" type="hidden" value="hits">
<input name="todate" type="hidden" value="lastyear">
<input style="cursor:pointer;" class="btn btn-sm btn-danger" type="submit" name="clearhits_submit" value="'.abTranslate('Older than a year').'">
</form>
</p>
';
